-- pralable
-- USE BD_Air_France;


IF OBJECT_ID('dbo.T_affreter_aff','U') IS NOT NULL
   DROP TABLE dbo.T_affreter_aff;
GO
IF OBJECT_ID('dbo.T_avion_avi','U') IS NOT NULL
   DROP TABLE dbo.T_avion_avi;
GO
IF OBJECT_ID('dbo.T_compagnie_cmp','U') IS NOT NULL
   DROP TABLE dbo.T_compagnie_cmp;
GO
IF OBJECT_ID('dbo.T_aeroport_aer','U') IS NOT NULL
   DROP TABLE dbo.T_aeroport_aer;
GO



CREATE TABLE T_aeroport_aer
 (aer_IATA   VARCHAR(3),
  aer_OACI   VARCHAR(6)  NOT NULL,
  aer_nom    VARCHAR(50) NOT NULL,
  CONSTRAINT PK_aer      PRIMARY KEY(aer_IATA),
  CONSTRAINT UK_aer_OACI UNIQUE(aer_OACI));
GO

CREATE TABLE T_compagnie_cmp
 (cmp_comp VARCHAR(4), cmp_effectif INT, aer_IATA VARCHAR(3), cmp_nom VARCHAR(30),
  CONSTRAINT PK_cmp     PRIMARY KEY(cmp_comp),
  CONSTRAINT FK_cmp_aer FOREIGN KEY(aer_IATA) REFERENCES T_aeroport_aer(aer_IATA));
GO

CREATE TABLE T_avion_avi
 (avi_immat VARCHAR(6), avi_typ VARCHAR(30), avi_hv DECIMAL(10,2), 
  aer_OACI  VARCHAR(6),
  CONSTRAINT PK_avi PRIMARY KEY(avi_immat),
  CONSTRAINT FK_avi_aer FOREIGN KEY(aer_OACI) REFERENCES T_aeroport_aer(aer_OACI));
GO


INSERT INTO T_aeroport_aer VALUES ('TLS','LFBO','Toulouse Blagnac');
INSERT INTO T_aeroport_aer VALUES ('ORY','LFPO','Paris Orly');
INSERT INTO T_aeroport_aer VALUES ('MRS','LFML','Marseille Provence');

INSERT INTO T_compagnie_cmp VALUES ('AF',6700,'ORY','Air France');
INSERT INTO T_compagnie_cmp VALUES ('AT',3400,'TLS','Tolosan Air');

INSERT INTO T_avion_avi VALUES ('F-WTSS','B777',6570,'LFML');
INSERT INTO T_avion_avi VALUES ('F-GFTR','B747',5000,'LFBO');
